/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.BaseDependencies;
import com.floragunn.searchguard.SearchGuardModule;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.enterprise.auditlog.AuditLogConfig;
import com.floragunn.searchguard.enterprise.auditlog.access_log.read.ReadLogDirectoryReaderWrapper;
import com.floragunn.searchguard.enterprise.auditlog.access_log.write.ComplianceIndexingOperationListenerImpl;
import com.floragunn.searchguard.enterprise.auditlog.impl.AuditLogImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import org.apache.lucene.index.DirectoryReader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexingOperationListener;

public class AuditLogModule
implements SearchGuardModule {
    private AuditLogImpl auditLog;
    private ComplianceIndexingOperationListenerImpl indexingOperationListener;
    private AuditLogConfig auditLogConfig;
    private boolean externalConfigLogged = false;

    public Collection<Object> createComponents(BaseDependencies baseDependencies) {
        if (baseDependencies.getSettings().get("searchguard.audit.type") != null) {
            this.auditLogConfig = new AuditLogConfig(baseDependencies.getEnvironment(), baseDependencies.getConfigurationRepository());
            this.auditLog = new AuditLogImpl(baseDependencies.getSettings(), baseDependencies.getEnvironment().configFile(), baseDependencies.getLocalClient(), baseDependencies.getThreadPool(), baseDependencies.getIndexNameExpressionResolver(), baseDependencies.getClusterService(), baseDependencies.getConfigurationRepository());
            this.auditLog.setComplianceConfig(this.auditLogConfig);
            baseDependencies.getLicenseRepository().subscribeOnLicenseChange(searchGuardLicense -> {
                this.auditLogConfig.onChange(searchGuardLicense);
                this.logExternalConfig(baseDependencies.getSettings(), baseDependencies.getEnvironment());
            });
            this.indexingOperationListener = new ComplianceIndexingOperationListenerImpl(this.auditLogConfig, this.auditLog, baseDependencies.getGuiceDependencies());
        }
        return ImmutableList.empty();
    }

    public ImmutableList<Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>>> getDirectoryReaderWrappersForAllOperations() {
        return this.auditLogConfig != null ? ImmutableList.of(indexService -> new ReadLogDirectoryReaderWrapper((IndexService)indexService, this.auditLog, this.auditLogConfig)) : ImmutableList.empty();
    }

    public ImmutableList<IndexingOperationListener> getIndexOperationListeners() {
        return this.indexingOperationListener != null ? ImmutableList.of((Object)this.indexingOperationListener) : ImmutableList.empty();
    }

    public AuditLog getAuditLog() {
        return this.auditLog;
    }

    private void logExternalConfig(Settings settings, Environment environment) {
        if (this.auditLogConfig.isEnabled() && !this.externalConfigLogged && this.auditLogConfig.isLogExternalConfig()) {
            this.auditLog.logExternalConfig(settings, environment);
            this.externalConfigLogged = true;
        }
    }
}

